DROP PROCEDURE IF EXISTS sp_insertUpdateContacto;

delimiter $
CREATE DEFINER=`targoxco`@`localhost` PROCEDURE sp_insertUpdateContacto(
	IN p_idContacto INT, IN p_idProveedor INT, 
    IN p_nombre VARCHAR(300), IN p_apePaterno VARCHAR(300), IN p_apeMaterno VARCHAR(300),
    IN p_celular VARCHAR(12), IN p_email VARCHAR(300),
    IN p_cargo VARCHAR(50), IN p_comentario VARCHAR(300), IN p_calificacion VARCHAR(300),
    IN p_usuario VARCHAR(50), IN p_activo int)
BEGIN
	IF p_idContacto = 0 THEN
		INSERT INTO CONTACTO (idProveedor,nombre,apePaterno, apeMaterno, cargo, dni, telefono, comentario, calificacion,
			email, fechaRegistro, usuarioRegistro, pcRegistro, activo)
		VALUES ( p_idProveedor, p_nombre, p_apePaterno, p_apeMaterno, p_cargo, '', p_celular, p_comentario, p_calificacion,
			p_email, 
            NOW(), p_usuario, '', 1);
            
		SELECT 1 as tipoRespuesta, 'El contacto se registró correctamente' as respuesta, last_insert_id() as idContacto;
    ELSE
		UPDATE CONTACTO
        SET 
			idProveedor = p_idProveedor, nombre = p_nombre, apePaterno = p_apePaterno, apeMaterno = p_apeMaterno, 
            cargo = p_cargo, telefono = p_celular, comentario = p_comentario, calificacion = p_calificacion, 
			email = p_email, 
            usuarioEdicion = p_usuario, fechaEdicion = NOW(), pcEdicion = '-',
            activo = p_activo
		WHERE idContacto = p_idContacto;
            
        SELECT 1 as tipoRespuesta, 'El contacto se editó correctamente' as respuesta, p_idContacto as idContacto;
	END IF;   
    
    
    -- SELECT  CONCAT(COLUMN_NAME, ','), COLUMN_NAME, DATA_TYPE, CHARACTER_MAXIMUM_LENGTH, IS_NULLABLE, COLUMN_DEFAULT
	-- FROM INFORMATION_SCHEMA.COLUMNS	  WHERE table_name = 'contacto'  AND table_schema = 'erp_targox';
END
$